model Ex16_6

extends Modelica.Math;
// Variable

Real Cp(unit ="J/g-mol-K")                      "Specific heat at constant pressure";

// Parameters

  parameter Real v1(unit ="")=1                    "";  
  parameter Real v2(unit ="")=0                    "";  
  parameter Real v3(unit ="")=1                    ""; 
  parameter Real v4(unit ="")=1/2                  ""; 
  parameter Real dH(unit ="J/g-mol")=250560        "Change in enthalpy"; 
  parameter Real e_(unit ="")=3.2e-03              "Degree of dissociation"; 
  parameter Real R(unit ="J / mol. K")=8.3143      "Characteristic gas constant";
  parameter Real T(unit ="K")=1900                 "Temperature"; 
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

Cp = ((dH^2)*(1+e_/2)*e_*(1+e_))/(R*T^2*(v1+v2)*(v3+v4));


end Ex16_6;
