model Ex16_7

extends Modelica.Math;
// Variable

Real PC(unit ="%")                      "Carbon percentage";
Real PH(unit ="%")                      "Hydrogen percentage";
Real AFR(unit ="")                      "Air fuel ratio";
Real EAU(unit ="%")                      "% excess air used";

// Parameters

  parameter Real a(unit ="")=21.89                    "";  
  parameter Real y(unit ="")=18.5                    "";  
  parameter Real x(unit ="")=8.9                    ""; 
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

PC = 100.*(x*12)/((x*12)+(y*1));
PH = 100-PC;
AFR = ((32*a)+(3.76*a*28))/((12*x)+y);
EAU = (8.8*32)*100/((a*32)-(8.8*32));



end Ex16_7;
