model Ex16_8

extends Modelica.Math;
// Variable

Real D(unit ="kJ")                      "";
Real QCV(unit ="kJ")                     "Heat transfer per kg mol of fuel";

// Parameters

  parameter Real hf_CO2(unit ="kJ")=-393522                    "";  
  parameter Real hf_H2O(unit ="kJ")=-285838                    "";  
  parameter Real hf_CH4(unit ="kJ")=-74874                    ""; 
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

D = hf_CO2 + (2*hf_H2O);
QCV = D - (hf_CH4+1);

end Ex16_8;
