model Ex17_2

extends Modelica.Math;
// Variables
Real w(unit ="kg/s")                       "Mass flow rate of air through the diffuser";
Real c1(unit ="m/s")                       "Velocity";
Real M1(unit ="")                          "Mach number";
Real A2_A1(unit ="")                       "Area ratio";
Real A2_A(unit ="")                        "Area ratio";
Real P2_P1(unit ="")                       "Pressure ratio";
Real T2_T1(unit ="")                       "Temperature ratio";
Real F2_F1(unit ="")                       "Force ratio";
Real P2(unit ="kPa")                       "Pressure";
Real T2(unit ="K")                         "Temperature";
Real F1(unit ="kN")                        "Impluse function at inlet";
Real F2(unit ="kN")                        "Impluse function at outlet";
Real T_int(unit ="kN")                     "Internal trust";
Real T_ext(unit ="kN")                     "External trust";
Real NT(unit ="kN")                        "Net trust";



// Parameters
  parameter Real P1(unit ="kPa")=180                  "Pressure";   
  parameter Real T1(unit ="K")=310                    "Temperature";
  parameter Real V1(unit ="m/s")=267                  "Velocity";
  parameter Real y(unit ="")=1.4                      "Specific heat ratio";
  parameter Real A1_A(unit ="")=1.0570                "Area ratio";              //A1/A*
  parameter Real P1_P01(unit ="")=0.68207             "pressure ratio";          //P1/P01
  parameter Real T1_T01(unit ="")=0.89644             "Temperature ratio";       //T1/T01
  parameter Real F1_F(unit ="")=1.0284                "Force ratio";             //F1/F*
  parameter Real A2(unit ="m^2")=0.44                 "Area";
  parameter Real A1(unit ="m^2")=0.11                 "Area";
  parameter Real R(unit ="kJ/kg*K")=0.287             "Gas constant";
  parameter Real M2(unit ="")=0.135                   "Mach number";
  parameter Real P2_P02(unit ="")=0.987               "pressure ratio";           //P2/P02
  parameter Real T2_T02(unit ="")=0.996               "Temperature ratio";        //T2/T02
  parameter Real F2_F(unit ="")=3.46                  "Force ratio";              //F2/F*
  parameter Real P0(unit ="kPa")=100                  "Atmospheric pressure";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation


w = (P1/(R*T1))*A1*V1;
c1 =sqrt(y*R*T1*1000);
M1 = V1/c1;
A2_A1 = A2/A1;
A2_A = A2_A1*A1_A;                        //A2/A*
P2_P1 = P2_P02/P1_P01;                    //P2/P1
T2_T1 = T2_T02/T1_T01;                    //T2/T1
F2_F1 = F2_F/F1_F;                        //F2/F1
P2 = P2_P1*P1;
T2 = T2_T1*T1;
F1 = P1*A1*(1+y*M1^2);
F2 = F2_F1*F1;
T_int = F2-F1;
T_ext = P0*(A2-A1);
NT = T_int - T_ext ;


end Ex17_2;
