package Ex17_3

model Ex17_3_a

extends Modelica.Math;
// Variables
Real P2(unit ="kPa")                           "Pressure";
Real T2(unit ="K")                             "Temperature";
Real c2(unit ="m/s")                           "Velocity";
Real V2(unit ="m/s")                           "Velocity";
Real P_(unit ="kPa")                           "Static Pressure";
Real T_(unit ="K")                             "Static Temperature";
Real rho_(unit ="kg/m^3")                      "Density";
Real V_(unit ="m/s")                           "Velocity at the exit from the nozzle";
Real w(unit ="kg/s")                           "Mass flow rate";



// Parameters
  parameter Real M2(unit ="")=2.197              "Mach number";   
  parameter Real p2_p0(unit ="")=0.0939          "pressure ratio";                    //p2/p0
  parameter Real T2_T0(unit ="")=0.5089          "Temperature ratio";                 //T2/T0
  parameter Real p0(unit ="kPa")=1000            "Stagnation pressure";
  parameter Real T0(unit ="K")=360               "Stagnation Temperature";
  parameter Real p_p0(unit ="")=0.528            "pressure ratio";                     // p*/p0
  parameter Real T_T0(unit ="")=0.833            "Temperature ratio";                  // T*/T0
  parameter Real At(unit ="m^2")=500e-06         "Nozzle area";
  parameter Real y(unit ="")=1.4                 "Specific heat ratio";
  parameter Real R(unit ="kJ/kg*K")=0.287        "Gas constant";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

P2 = p2_p0*p0;
T2 = T2_T0*T0;
c2 = sqrt(y*R*T2*1000);
V2 = c2*M2;
P_ = p_p0*p0; 
T_ = T_T0*T0;
rho_ = P_/(R*T_);
V_ = sqrt(y*R*T_*1000); 			
w = At*V_*rho_;



end Ex17_3_a;
//=========================================================================================

model Ex17_3_b

extends Modelica.Math;
// Variables
Real P2b(unit ="kPa")                       "Pressure";
Real T2b(unit ="K")                         "Temperature";
Real c2b(unit ="m/s")                       "Velocity";
Real V2b(unit ="m/s")                       "Velocity";


// Parameters
  parameter Real Mb(unit ="")=0.308              "Mach number";   
  parameter Real P2_P0b(unit ="")=0.936          "pressure ratio";            //P2/P0
  parameter Real T2_T0b(unit ="")=0.9812         "Temperature ratio";         //T2/T0
  parameter Real P0(unit ="kPa")=1000            "Stagnation pressure";
  parameter Real T0(unit ="K")=360               "Stagnation Temperature";
  parameter Real y(unit ="")=1.4                 "Specific heat ratio";
  parameter Real R(unit ="kJ/kg*K")=0.287        "Gas constant";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation


P2b = P2_P0b*P0;
T2b = T2_T0b*T0;
c2b = sqrt(y*R*T2b*1000);
V2b = c2b*Mb;



end Ex17_3_b;

//===============================================================================================
end Ex17_3;
