model Ex17_7

extends Modelica.Math;
// Variable
Real Py(unit ="bar")                          "Pressure";
Real Pox(unit ="bar")                         "Stagnation pressure";
Real Tox(unit ="K")                           "Stagnation temperature";       
Real sysx(unit ="kJ/kg*K")                    "change in specific entropy";


// Parameters

  parameter Real Px(unit ="bar")=0.5               "Pressure";
  parameter Real Tx(unit ="K")=280                 "Temperature";
  parameter Real Ty(unit ="K")=429                 "Temperature";
  parameter Real Mx(unit ="")=1.8                  "Mach number";
  parameter Real Py_Px(unit ="")=3.6133            "pressure ratio"; // From gas tables
  parameter Real y(unit ="")=1.4                   "Specific heat ratio";
  parameter Real Cp(unit ="kJ/kg*K")=1.005         "Specific heat at constant pressure";
  parameter Real R(unit ="kJ/kg*K")=0.287          "Gas constant";
  parameter Real Pxox(unit ="")=0.17404            "pressure ratio";         //Px/Pox
  parameter Real Txox(unit ="")=0.60680            "Temperature ratio";      //Tx/Tox
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation


Py=Py_Px*Px;
Pox = Px/Pxox;
Tox = Tx/Txox; 
sysx = Cp*log(Ty/Tx)-R*log(Py/Px);


end Ex17_7;
