model Ex2_2

//variables
Real E1(unit="mV")                   "e.m.f. in thermocouple at ice point";
Real E2(unit="mV")                   "e.m.f. in thermocouple at steam point";
Real E3(unit="mV")                   "e.m.f. in thermocouple at gas thermometer reading";
Real T(unit="degree celsius")        "Temperature"      ;

// Parameters
parameter Real t1(unit="degree celsius")=0      "temperature of thermocouple at ice point";
parameter Real t2(unit="degree celsius")=100    "temperature of thermocouple at steam point";
parameter Real t3(unit="degree celsius")=50     "gas thermometer reading"; 

// Equations   
equation
E1=0.20*t1-5e-04*t1^2;                 //e.m.f. in thermocouple at ice point
E2=0.20*t2-5e-04*t2^2;                 //e.m.f. in thermocouple at steam point
E3=0.20*t3-5e-04*t3^2;                 //e.m.f. in thermocouple at gas thermometer reading


//when the gas thermometer reads 50 degree celsius, the thermocouple will read temperature T 
T=E3*(100/15);

end Ex2_2;
