package Ex4_6

model Ex4_6_a
//process 1-2 isochoric heat addition
// Variables
Real U1_2(unit="kJ/kg")                  "Change in internal energy";

 parameter Real Q1_2(unit="kJ/kg")=235     "heat addition at constant volume";
 parameter Real W1_2(unit="kJ/kg")=0       "Work done at constant volume";
 
equation 

U1_2=Q1_2-W1_2;                    //Change in internal energy

end Ex4_6_a;
//=================================================================================================

model Ex4_6_b
//process 2-3 adiabatic expansion
// Variables
Real W2_3(unit="kJ/kg")                "Work done in adiabatic process";
// Parameters
 parameter Real Q2_3(unit="kJ/kg")=0    "heat addition in adiabatic process";
 parameter Real U2_3(unit="kJ/kg")=-70      "Change in internal energy in adiabatic process";
 // Equations
equation 

W2_3=Q2_3-U2_3;                    //Work done in adiabatic process

end Ex4_6_b;

//===============================================================================================

model Ex4_6_c
//process 3-1 isobaric compression
// Variables
Real W3_1(unit="kJ/kg")                "Work done at constant pressure";
Real U3_1(unit="kJ/kg")                "Change in internal energy at constant pressure";

// Parameters
 parameter Real Q3_1(unit="kJ/kg")=-200    "Heat rejection at constant pressure";
 parameter Real U1_2(unit="kJ/kg")=235    "Change in internal energy at constant volume"; //calculated in part (a)
 parameter Real U2_3(unit="kJ/kg")=70    "Change in internal energy in adiabatic process"; //calculated in part (b)
 // Equations
equation 

U3_1=-U1_2+U2_3;               //Change in internal energy at constant pressure
W3_1=Q3_1-(U3_1);                //Work done in adiabatic process


end Ex4_6_c;
//=================================================================================================

model Ex4_6_d
// Variables
Real Q(unit="kJ/kg")             "Sum of heat transfer";
Real W(unit="kJ/kg")             "Sum of work transfer";

// Parameters
 parameter Real W1_2(unit="kJ/kg")=0       "Work done at constant volume";
 parameter Real W2_3(unit="kJ/kg")=70      "Work done in adiabatic process"; //calculated in part (b)
 parameter Real W3_1(unit="kJ/kg")=-35    "Work done at constant pressure";  //calculated in part (c)
 parameter Real Q1_2(unit="kJ/kg")=235     "Heat addition at constant volume";
 parameter Real Q2_3(unit="kJ/kg")=0       "Heat transfer in adiabatic process";
 parameter Real Q3_1(unit="kJ/kg")=-200     "Heat rejection at constant pressure";
// Equations
equation

Q=Q1_2+Q2_3+Q3_1;                       //Sum of heat transfer
W=W1_2+W2_3+W3_1;                       //Sum of work transfer

//sum of heat transfer=sum of work transfer
//This cycle is known as Lenoir cycle, and the operation of pulse jet approximates to it.

end Ex4_6_d;


end Ex4_6;
