package Ex5_1


model Ex5_1_a
extends Modelica.Math;
// Variables

Real dW(unit="kW")                       "Work input to the air";


// Parameters
 
 
 parameter Real m(unit="kg/s")=0.5                       "Mass flow rate"; 
 parameter Real delta_u(unit="kJ/kg")=90                 "Change in internal energy";
 parameter Real p2(unit="kPa")=700                       "Final pressure";
 parameter Real p1(unit="kPa")=100                       "Initial pressure";
 parameter Real v2(unit="m^3/kg")=0.19                   "Final specific volume"; 
 parameter Real v1(unit="m^3/kg")=0.95                   "Initial specific volume" ; 
 parameter Real V2(unit="m/s")=5                         "Final velocity" ;
 parameter Real V1(unit="m/s")=7                         "Initial velocity" ;
 parameter Real Z2(unit="m")=0                           "Final height" ;
 parameter Real Z1(unit="m")=0                           "Initial height" ;
 parameter Real dQ(unit="kW")=-58                        "Rate of heat absorbed from the air" ;
 parameter Real g(unit="m/s^2")=9.8                      "Gravitatinal acceleration" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation
//Steady flow energy equation
dW=-m*(delta_u+(p2*v2-p1*v1)+(V2^2-V1^2)*1e-03/2+((Z2-Z1)*g))+dQ;             //W = dW/dt

//The  answer may slightly vary due to  rounding off values
end Ex5_1_a;

//=============================================================================================
model Ex5_1_b

// Variables

Real d0(unit="")                "Ratio of inlet pipe diameter to outlet pipe diameter"; //d0=d1/d2


// Parameters
 
 
 parameter Real v2(unit="m^3/kg")=0.19                   "Final specific volume"; 
 parameter Real v1(unit="m^3/kg")=0.95                   "Initial specific volume" ; 
 parameter Real V2(unit="m/s")=5                         "Final velocity" ;
 parameter Real V1(unit="m/s")=7                         "Initial velocity" ;


 // Equations

equation

d0=sqrt((v1*V2)/(v2*V1));          // d0 = d1/d2


end Ex5_1_b;

end Ex5_1;
