model Ex5_3

extends Modelica.Math;
//Variables
Real V1(unit="m/s")                        "Initial velocity";
Real A1(unit="m^2")                        "Area";
Real w(unit="kg/s")                        "Mass flow rate";

// Parameters
 parameter Real h1(unit="kJ/kg")=3213.6         "Enthalpy"; 
 parameter Real h2(unit="kJ/kg")=3202.6         "Enthalpy"; 
 parameter Real dQ_dm(unit="kJ/kg")=-8.5        "Heat loss from the pipeline"; 
 parameter Real v1(unit="m^3/kg")=0.073         "Specific Volume";   
 parameter Real d(unit="m")=0.2                 "Diameter"; 
 
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
  
 // Equations
equation

((1.15*V1)^2-(V1^2))=2000*((h1-h2)+dQ_dm);
A1=pi*d^2/4;
w=A1*V1/v1;


//The  answer may slightly vary due to  rounding off values.


end Ex5_3;
