model Ex5_6
extends Modelica.Math;
// Variables

Real dW(unit="kW")                      "Power input of the turbine";
Real V01(unit="m^3/s")                  "Volume flow rate at inlet";
Real A1(unit="m^2")                     "Inlet area";
Real D1(unit="m")                       "diameter of the inlet pipe";


// Parameters
 
 
 parameter Real w(unit="kg/s")=5                   "Mass flow rate"; 
 parameter Real p1(unit="Pa")=100e03               "Inlet pressure of turbine";
 parameter Real T1(unit="K")=300                   "Inlet temperature of turbine";
 parameter Real h1(unit="kJ/kg")=900               " Inlet enthalpy";
 parameter Real h2(unit="kJ/kg")=400               "Outlet enthalpy"; 
 parameter Real V1(unit="m/s")=50                  "Initial velocity" ;
 parameter Real V2(unit="m/s")=150                 "Final velocity" ;
 parameter Real Z2(unit="m")=0                     "Final height" ;
 parameter Real Z1(unit="m")=0                     "Initial height" ;
 parameter Real dQ(unit="kW")=-25                  "Rate of heat absorbed from the air" ;
 parameter Real g(unit="m/s^2")=9.8                "Gravitational acceleration" ;
 parameter Real Cp(unit="kJ/kg*K")=1.004           "Specific heat at constant pressure" ;
 parameter Real R(unit="kJ/kg*K")=0.285            "Gas constant" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 // Equations

equation

dW=w*((h1-h2)+(V1^2-V2^2)*1e-03/2+((Z2-Z1)*g)+dQ);
V01=w*R*T1*1e03/p1;
A1=V01/V1;
D1=sqrt((4*A1)/pi);

end Ex5_6;
