model Ex5_9

extends Modelica.Math;
// Variable

Real u0(unit ="kJ/kg")                              "Internal energy";
Real hp(unit ="kJ/kg")                              "Enthalpy";       
Real dm_dt(unit ="kg/s")                           "Mass flow rate of air";

// Parameters

  parameter Real u(unit ="kJ/kg")=0                       "Internal energy";   
  parameter Real t(unit ="degree celsius")=-273           "Temperature";   
  parameter Real T(unit ="degree celsius")=150            "Temperature";   
  parameter Real dW_dt(unit ="kJ/s")=0.1                  "Power to paddle wheel";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

u=u0+(0.718*t);
hp=1.005*(T+273);
dm_dt=dW_dt/hp;


end Ex5_9;
