package Ex6_5


model Ex6_5_a
// Variables
Real n_max(unit="")                               "maximum Efficiency of the heat engine cycle";
Real W1(unit="kJ")                                "Work done by heat engine";
Real COP(unit="")                                 "Coefficient of performance";
Real W2(unit="kJ")                                "Work done on the refrigerator";
Real Q4(unit="kJ")                                "Heat absorbed by refrigerator ";
Real Q3(unit="kJ")                                "Heat rejected by refrigerator ";
Real Q2(unit="kJ")                                "Heat rejected by heat engine ";
Real Q_rej(unit="kJ")                             "Net heat transfer";


// Parameters
 parameter Real T1(unit="K")=873                 "Source temperature of reversible heat engine"; 
 parameter Real T2(unit="K")=313                 "Sink temperature for both"; 
 parameter Real T3(unit="K")=253                 "Source temperature of reversible refrigerator";   
 parameter Real Q1(unit="kJ")=2000               "Heat addition";
 parameter Real W(unit="kJ")=360                 "Net work output";

 
 // Equations
equation 
n_max=1-(T2/T1);
W1=n_max*Q1;
COP=T3/(T2-T3);
W2=W1-W;
Q4=COP*W2;
Q3=Q4+W2;
Q2=Q1-W1;
Q_rej=Q2+Q3;      


end Ex6_5_a;

//==========================================================================================

model Ex6_5_b

// Variables
Real n(unit="")                                   "Efficiency of the actual heat engine cycle";
Real n_max(unit="")                               "Maximum Efficiency";
Real W1(unit="kJ")                                "Work done by heat engine";
Real COP_max(unit="")                             "Maximum Coefficient of performance";
Real COP(unit="")                                 "Coefficient of performance";
Real W2(unit="kJ")                                "Work done on refrigerator";
Real Q4(unit="kJ")                                "Heat absorbed by refrigerator ";
Real Q3(unit="kJ")                                "Heat rejected by refrigerator ";
Real Q2(unit="kJ")                                "Heat rejected by heat engine ";
Real Q_rej(unit="kJ")                             "Net heat transfer";


// Parameters
 parameter Real T1(unit="K")=873                 "Source temperature of reversible heat engine"; 
 parameter Real T2(unit="K")=313                 "Sink temperature for both"; 
 parameter Real T3(unit="K")=253                 "Source temperature of reversible refrigerator";   
 parameter Real Q1(unit="kJ")=2000               "Heat addition";
 parameter Real W(unit="kJ")=360                 "Net work output";

 
 // Equations
equation 
n_max=1-(T2/T1);
n=0.4*n_max;
W1=n*Q1;
W2=W1-W;
COP_max=T3/(T2-T3);
COP=0.4*COP_max;
Q4=COP*W2;
Q3=Q4+W2;
Q2=Q1-W1;
Q_rej=Q2+Q3;      


end Ex6_5_b;

//The  answer may slightly vary due to  rounding off values.
end Ex6_5;
