package Ex7_3

model Ex7_3_a
extends Modelica.Math;
// Variables
Real Q(unit="kJ")                           "Amount of heat absorbed by ice";
Real delta_S_atm(unit="kJ/K")               "Entropy change of the atmosphere";
Real delta_S1(unit="kJ/K")                 "Entropy change of water as it gets heated from -5 degree celsius to 0 degree celsius";
Real delta_S2(unit="kJ/K")                 "Entropy change of the system as ice melts at 0 degree celsius to become water at 0 degree celsius";
Real delta_S3(unit="kJ/K")                 "Entropy change of water as it gets heated from 0 degree celsius to 20 degree celsius";
Real delta_S_total(unit="kJ/K")            "Total entropy change of ice as it melts into water";
Real delta_S_univ(unit="kJ/K")             "Entropy change of the universe";

// Parameters

 parameter Real T0(unit="K")=273                 "Equilibrium temperature"; 
 parameter Real T1(unit="K")=268                 "Temperature of Ice"; 
 parameter Real T2(unit="K")=293                 "Atmospheric Temperature"; 
 parameter Real Cp(unit="KJ/Kg*K")=2.093         "Specific heat of ice at constant pressure";   
 parameter Real C(unit="KJ/Kg*K")=4.187         "Specific heat at constant pressure";
 parameter Real m(unit="Kg")=1                   "Mass";
 parameter Real L(unit="KJ/Kg")=333.3            "Latent heat of fusion of ice"; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation 
//heat absorbed by ice Q from atmosphere=Heat absorbed in solid phase+latent heat+ Heat absorbed in liquid phase
Q=(m*Cp*(T0-T1))+(m*L)+(m*C*(T2-T0));
delta_S_atm=-Q/T2;
delta_S1=m*Cp*log(T0/T1);
delta_S2=L/T0;
delta_S3=m*C*log(T2/T0);
delta_S_total=delta_S1+delta_S2+delta_S3;
delta_S_univ=delta_S_total+delta_S_atm;

end Ex7_3_a;

//==================================================================================================


model Ex7_3_b
extends Modelica.Math;
// Variables
Real Q(unit="kJ")                                       "Amount of heat absorbed by ice";
Real delta_S1(unit="kJ/K")                 "Entropy change of water as it gets heated from -5 degree celsius to 0 degree celsius";
Real delta_S2(unit="kJ/K")                 "Entropy change of the system as ice melts at 0 degree celsius to become water at 0 degree celsius";
Real delta_S3(unit="kJ/K")                 "Entropy change of water as it gets heated from 0 degree celsius to 20 degree celsius";
Real delta_S_total(unit="kJ/K")            "Total entropy change of ice as it melts into water";
Real W_min(unit="kJ")             "Minimum amount of work done used to convert the water back into ice at -5 degree celcsius";

// Parameters

 parameter Real T0(unit="K")=273                 "Equilibrium temperature"; 
 parameter Real T1(unit="K")=268                 "Temperature of Ice"; 
 parameter Real T2(unit="K")=293                 "Atmospheric Temperature"; 
 parameter Real Cp(unit="KJ/Kg*K")=2.093         "Specific heat of ice at constant pressure";   
 parameter Real C(unit="KJ/Kg*K")=4.187         "Specific heat at constant pressure";
 parameter Real m(unit="Kg")=1                   "Mass";
 parameter Real L(unit="KJ/Kg")=333.3            "Latent heat of fusion of ice"; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation 
//heat absorbed by ice Q from atmosphere=Heat absorbed in solid phase+latent heat+ Heat absorbed in liquid phase
Q=(m*Cp*(T0-T1))+(m*L)+(m*C*(T2-T0));
delta_S1=m*Cp*log(T0/T1);
delta_S2=L/T0;
delta_S3=m*C*log(T2/T0);
delta_S_total=delta_S1+delta_S2+delta_S3;
W_min=T2*delta_S_total-Q;


end Ex7_3_b;


end Ex7_3;
