model Ex7_5

extends Modelica.Math;
// Variables
Real n1(unit="")                                   "";
Real n2(unit="")                                   "";
Real x1(unit="")                                   "Mole fraction of oxygen";
Real x2(unit="")                                   "Mole fraction of hydrogen";
Real S(unit="J/K")                                 "Change in entropy";



// Parameters
 parameter Real Vo(unit="l")=8.4               "STP of oxygen"; 
 parameter Real Vh(unit="l")=14                "STP of hydrogen"; 
 parameter Real R(unit="KJ/Kg*K")=8.31         "Gas constant";
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation

n1 = Vo/22.4; 
n2 = Vh/22.4;
x1 = n1/(n1+n2);
x2 = n2/(n1+n2);
S = -R*(n1*log(x1)+n2*log(x2));

end Ex7_5;
