model Ex8_15


// Variables

Real Q(unit="kJ")                       "Exergy";


// Parameters
 
 
 parameter Real H(unit="kW")=0            "Enthalpy"; //since a vacuum has zero mass
 parameter Real H0(unit="kW")=0           "Enthalpy"; //If the vacuum was reduced to the dead state 
 parameter Real p(unit="kPa")=0           "Pressure" ;  //pressure is 0 for the vacuum
 parameter Real p0(unit="kPa")=100        "Pressure" ;
 parameter Real V(unit="m^3")=1           "Volume" ;
 parameter Real T0(unit="K")=0            "Volume" ;
 parameter Real S(unit="kJ/kg*K")=0       "Entropy" ;  //since a vacuum has zero mass
 parameter Real S0(unit="kJ/kg*K")=0      "Entropy" ; //If the vacuum was reduced to the dead state
 
 // Equations

equation
Q=(H-H0)-(V*(p-p0))-(T0*(S-S0));

end Ex8_15;
