model Ex9_15

extends Modelica.Math;

// Variables
Real h3(unit="kJ/kg")                         "Enthalpy";
Real s3(unit="kJ/kg*K")                       "Entropy";
Real w1(unit="kJ/kg")                         "Availability of steam entering the turbine";
Real w2(unit="kJ/kg")                         "Availability of steam leaving the turbine at state 2";
Real w3(unit="kJ/kg")                         "Availability of steam leaving the turbine at state 3";
Real W_rev(unit="kJ/kg")                      "Minimum work per kg of steam entering the turbine";
Real I(unit="kJ/h")                           "Irreversibility";


// Parameters
  parameter Real m1(unit="kg")=600             "Rate of mass of steam received by turbine";
  parameter Real m2(unit="kg")=150             "Rate of mass of steam extracted";
  parameter Real m3(unit="kg")=450             "Rate of mass of steam leaves the turbine";
  parameter Real T0(unit="K")=303              "Atmospheric temperature";
  parameter Real Q(unit="kJ/h")=-36000         "Heat transfer from the turbine to the surroundings";
  
 // From the mollier diagram,at 25 bar and 350 degree celsius
 
 parameter Real s1(unit="kJ/kg*K")=6.8481                "Entropy";
 parameter Real h1(unit="kJ/kg")=3125.87                 "Enthalpy of gas";
 
 // From the mollier diagram, at 25 bar and 200 degree celsius
 
 parameter Real s0(unit="kJ/kg*K")=0.4369                "Entropy";
 parameter Real h0(unit="kJ/kg")=125.79                  "Enthalpy";
 
 // From the mollier diagram,at 3 bar and 200 degree celsius
 
 parameter Real h2(unit="kJ/kg")=2865.5                 "Enthalpy";
 parameter Real s2(unit="kJ/kg*K")=7.3115               "Entropy";
 
 // From the mollier diagram,at 0.2 bar and 0.92 dry
 parameter Real x(unit="")=0.92                        "dryness fraction";
 parameter Real hf(unit="kJ/kg")=251.4                 "Enthalpy";
 parameter Real hfg(unit="kJ/kg")=2358.3               "Enthalpy";
 parameter Real sf(unit="kJ/kg*K")=0.8320              "Entropy";
 parameter Real sg(unit="kJ/kg*K")=7.9085              "Entropy";
 
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

 // Equations

equation
h3=hf+x*hfg;
s3=sf+x*(sg-sf);
w1=(h1-h0)-T0*(s1-s0);
w2=(h2-h0)-T0*(s2-s0);
w3=(h3-h0)-T0*(s3-s0);
W_rev=w1-w2*(m2/m1)-w3*(m3/m1);
I=T0*(m2*s2+m3*s3-m1*s1)-Q;

end Ex9_15;
