package Ex9_17
model Ex9_17_a


// Variables
Real mh_parallel(unit="kg/s")               "Hot water flow in parallel flow";
Real mh_counter(unit="kg/s")                "Hot water flow in counter flow";
Real af1(unit="kW")                         "";
Real Eg(unit="kW")                          "Rate of exergy gain";
Real El(unit="kW")                          "Rate of exergy loss by hot water";
Real n2_p(unit="")                          "Second law efficiency";
Real n2_P(unit="")                          "Second law efficiency";
Real E(unit="kW")                           "Rate of irreversibility or exergy destruction";


// Parameters
  parameter Real mc(unit="kg/s")=1                 "Cold water flow rate";
  parameter Real Cc(unit="kJ/kg*K")=1              "Heat capacity flow rate of cold fluid";
  parameter Real Ch(unit="kJ/kg*K")=1              "Heat capacity flow rate of hot fluid";
  parameter Real T0(unit="K")=300                  "Surrounding temperature";
  parameter Real th1(unit="degree celsius")=90     "Inlet hot water temperature";
  parameter Real th2_p(unit="degree celsius")=60   "Outlet hot water temperature in parallel flow";
  parameter Real th2_c(unit="degree celsius")=35   "Outlet hot water temperature in counter flow";
  parameter Real tc1(unit="degree celsius")=25     "Inlet cold water temperature";
  parameter Real tc2(unit="degree celsius")=50     "Outlet cold water temperature";
  
  
 // From the mollier diagram,at 300 K
 
 parameter Real s0(unit="kJ/kg*K")=0.395               "Entropy";
 parameter Real h0(unit="kJ/kg")=113.2                 "Enthalpy of gas";
 
 
 // From the mollier diagram, at 90 degree celsius
 
 parameter Real s1(unit="kJ/kg*K")=1.1925                "Entropy";
 parameter Real h1(unit="kJ/kg")=376.92                  "Enthalpy";

 // From the mollier diagram, at 60 degree celsius
 
 parameter Real s2(unit="kJ/kg*K")=0.8312                "Entropy";
 parameter Real h2(unit="kJ/kg")=251.13                  "Enthalpy";

 // From the mollier diagram, at 25 degree celsius
 
 parameter Real s3(unit="kJ/kg*K")=0.3674                "Entropy";
 parameter Real h3(unit="kJ/kg")=104.89                 "Enthalpy";

 // From the mollier diagram, at 50 degree celsius
 
 parameter Real s4(unit="kJ/kg*K")=0.7038                "Entropy";
 parameter Real h4(unit="kJ/kg")=209.33                  "Enthalpy";

 // Equations

equation

mh_parallel=mc*Cc*(tc2-tc1)/(Ch*(th1-th2_p));
mh_counter=mc*Cc*(tc2-tc1)/(Ch*(th1-th2_c));
af1=mh_parallel*((h1-h0)-T0*(s1-s0));
Eg=mc*((h4-h3)-T0*(s4-s3));
n2_p=Eg/af1;
El=mh_parallel*((h1-h2)-T0*(s1-s2));
E=El-Eg;
n2_P=Eg/El;


end Ex9_17_a;
//===================================================================================================


model Ex9_17_b


// Variables
Real mh_parallel(unit="kg/s")               "Hot water flow in parallel flow";
Real mh_counter(unit="kg/s")                "Hot water flow in counter flow";
Real af1(unit="kW")                         "";
Real Eg(unit="kW")                          "Heat capacity flow rate of cold fluid";
Real El(unit="kW")                          "Heat capacity flow rate of hot fluid";
Real n2_p(unit="")                          "Second law efficiency";
Real n2_P(unit="")                          "Second law efficiency";
Real E(unit="kW")                           "Rate of irreversibility or exergy destruction";


// Parameters
  parameter Real mc(unit="kg/s")=1                   "Cold water flow rate";
  parameter Real Cc(unit="kg/s")=1                   "";
  parameter Real Ch(unit="kg/s")=1                   "";
  parameter Real T0(unit="K")=300                    "Surrounding temperature";
  parameter Real th1(unit="degree celsius")=90       "Inlet hot water temperature";
  parameter Real th2_p(unit="degree celsius")=60     "Outlet hot water temperature in parallel flow";
  parameter Real th2_c(unit="degree celsius")=35     "Outlet hot water temperature in counter flow";
  parameter Real tc1(unit="degree celsius")=25       "Inlet cold water temperature";
  parameter Real tc2(unit="degree celsius")=50       "Outlet cold water temperature";
  
  
 // From the mollier diagram,at 300 K
 
 parameter Real s0(unit="kJ/kg*K")=0.395               "Entropy";
 parameter Real h0(unit="kJ/kg")=113.2                 "Enthalpy of gas";
 
 
 // From the mollier diagram, at 90 degree celsius
 
 parameter Real s1(unit="kJ/kg*K")=1.1925                "Entropy";
 parameter Real h1(unit="kJ/kg")=376.92                  "Enthalpy";

 // From the mollier diagram, at 35 degree celsius
 
 parameter Real s2(unit="kJ/kg*K")=0.5053                "Entropy";
 parameter Real h2(unit="kJ/kg")=146.68                  "Enthalpy";

 // From the mollier diagram, at 25 degree celsius
 
 parameter Real s3(unit="kJ/kg*K")=0.3674                "Entropy";
 parameter Real h3(unit="kJ/kg")=104.89                 "Enthalpy";

 // From the mollier diagram, at 50 degree celsius
 
 parameter Real s4(unit="kJ/kg*K")=0.7038                "Entropy";
 parameter Real h4(unit="kJ/kg")=209.33                  "Enthalpy";

 // Equations

equation

mh_parallel=mc*Cc*(tc2-tc1)/(Ch*(th1-th2_p));
mh_counter=mc*Cc*(tc2-tc1)/(Ch*(th1-th2_c));
af1=mh_counter*((h1-h0)-T0*(s1-s0));
Eg=mc*((h4-h3)-T0*(s4-s3));
n2_p=Eg/af1;
El=mh_counter*((h1-h2)-T0*(s1-s2));
E=El-Eg;
n2_P=Eg/El;


end Ex9_17_b;


end Ex9_17;
