model Ex9_4


// Variables

Real h(unit="kJ/kg")                     "Enthalpy";
Real s(unit="kJ/kg*K")                   "Entropy";
Real v(unit="m^3/kg")                    "Specific colume";

// Parameters
 parameter Real p(unit="MPa")=1.4                              "Pressure";
 parameter Real T1(unit="degree celsius")=350                   "Temperature"; 
 // According to steam table, when p=1.4 MPa and T=350 degree celsius
 parameter Real v1(unit="m^3/kg")=0.2003                       "Spcific volume";
 parameter Real h1(unit="kJ/kg")=3149.5                        "Enthalpy"; 
 parameter Real s1(unit="kJ/kg*K")=7.1360                      "Entropy";
 
 parameter Real T2(unit="degree celsius")=400                   "Temperature"; 
 //According to steam table, when p=1.4 MPa and T=400 degree celsius
 parameter Real v2(unit="m^3/kg")=0.2108                        "Spcific volume";
 parameter Real h2(unit="kJ/kg")=3257.5                         "Enthalpy";
 parameter Real s2(unit="kJ/kg*K")=7.3026                       "Entropy";
 
 parameter Real T0(unit="degree celsius")=380                   "Temperature"; 
 // Equations

equation
//By interpolation at 1.4 MPa, 380 degree celsius
v=v1+((T0-T1)*(v2-v1)/(T2-T1));
h=h1+((T0-T1)*(h2-h1)/(T2-T1));
s=s1+((T0-T1)*(s2-s1)/(T2-T1));

end Ex9_4;
