model Ex1_2

// Variables
Real P0(unit="Pa")                                "atmospheric pressure";
Real P1(unit="MPa")                               "inlet steam pressure";
Real P2(unit="kPa")                               "Condenser pressure";

// Parameters
 parameter Real P_gauge(unit="kPa")=1.4e06        "Gauge pressure";
 parameter Real z0(unit="m")=772e-03              "reading of barometer";
 parameter Real rho(unit="kg/m^3")=13.6e03        "density of mercury";
 parameter Real g(unit="m/s^2")=9.81              "acceleration due to gravity";
 parameter Real z(unit="m")=710e-03               "difference in height";
 
// Equations
equation

P0=(rho*g*z0);                                    //atmospheric pressure(approx.)
P1=(P0+P_gauge)/1e06;                             //inlet steam pressure
P2=(rho*g*(z0-z))/1e03;                           //Condenser pressure

end Ex1_2;
