model Ex10_16

extends Modelica.Math;
// Variables
Real R_O2(unit ="kJ/kg*K")                         "Gas constant for oxygen";
Real R_N2(unit ="kJ/kg*K")                         "Gas constant for nitrogen";
Real p_O2(unit ="")                                "Mole fraction";
Real p_N2(unit ="")                                "Mole fraction";
Real p(unit ="")                                   "Total mole fraction";
Real x_O2(unit ="")                                "";
Real x_N2(unit ="")                                "";
Real delta_S(unit ="kJ/kg*K")                      "Entropy increase due to diffusion";


// Parameters
  
  parameter Real m_O2(unit ="kg")=2               "Mass of oxygen";
  parameter Real m_N2(unit ="kg")=6               "Mass of nitrogen";
  parameter Real R(unit ="kJ/kg*K")=8.3143        "Gas constant";
  parameter Real M_O2(unit ="")=32                "Mole of oxygen";
  parameter Real M_N2(unit ="")=28                "Mole of nitrogen";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation
R_O2=R/M_O2;
R_N2=R/M_N2;
p_O2=m_O2/M_O2;
p_N2=m_N2/M_N2;
p=p_O2+p_N2;
x_O2=p_O2/p;
x_N2=p_N2/p;
//Entropy increase due to diffusion
delta_S=-m_O2*R_O2*log(p_O2/p)-m_N2*R_N2*log(p_N2/p);

end Ex10_16;
