model Ex10_17


extends Modelica.Math;
// Variables
Real P(unit ="kPa")                         "Pressure";
Real T(unit ="K")                           "Temperature";
Real v(unit ="m^3/kg")                      "Specific volume";
Real vr(unit ="")                           "Reduced volume";



// Parameters
  
  parameter Real w(unit ="")=20.183               "Molecular weight";
  parameter Real Pr(unit ="")=2                   "Reduced pressure";
  parameter Real Pc(unit ="kPa")=2730             "Critical pressure";
  parameter Real Tr(unit ="")=1.3                 "Reduced temperature";
  parameter Real Tc(unit ="K")=44.5               "Critical temperature";
  parameter Real vc(unit ="m^3/kg-mol")=0.0416    "Critical specific volume";
  parameter Real Z(unit ="")=0.7                  "Compressibility factor";
  parameter Real R(unit ="kJ/kg*K")=8.3143        "Gas constant";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

P=Pr*Pc;
T=Tr*Tc;
v=Z*R*T/(P*w);
vr=v*w/vc;

end Ex10_17;
