package Ex10_2

model Ex10_2_a          
//The fluid is air

// Variables
Real p(unit="kPa")                         "Pressure";
Real W(unit="kJ")                          "Work";
Real T2(unit="K")                          "Final temperature";
Real Q(unit="kJ")                          "Heat transferred";


// Parameters
  
  parameter Real T1(unit="K")=423                     "Temperature at state 1";
  parameter Real v1(unit="m^3/kg")=0.96               "Specific volume at state 1";
  parameter Real v2(unit="m^3/kg")=1.55               "Specific volume at state 2";
  parameter Real R(unit="kJ/kg*K")=0.287              "Gas constant";
  parameter Real Cp(unit="kJ/kg*K")=1.005             "Specific heat at constant pressure";
  
 // Equations
equation

p=R*T1/v1;
W=p*(v2-v1);
T2=T1*(v2/v1);
Q=Cp*(T2-T1);


end Ex10_2_a;

//===============================================================================================

model Ex10_2_b          
//The fluid is steam

// Variables

Real W(unit="kJ")                                      "Work";
Real Q(unit="kJ")                                      "Heat transferred";
Real T2(unit="degree celsius")                         "Final temperature";

// Parameters
  parameter Real v1(unit="m^3/kg")=0.96                  "Specific volume at state 1";
  //from steam table,at 150 degree celsius
  parameter Real vg(unit="m^3/kg")=0.3928                "Specific volume";
  //since v1>vg, the state is superheated.
  //From superheated steam table
  
  parameter Real p1(unit="kPa")=200                      "Pressure at state 1";
  parameter Real h1(unit="kJ/kg")=2768.8                 "Enthalpy at state 1";
  parameter Real v2(unit="m^3/kg")=1.55                  "Specific volume at state 2";
  parameter Real t2(unit="degree celsius")=400           "Final temperature";
  parameter Real h2(unit="kJ/kg")=3276.5                 "Enthalpy at state 2";
  
 // Equations
equation

Q=h2-h1;
W=p1*(v2-v1);
T2=t2;

end Ex10_2_b;

end Ex10_2;
