package Ex10_5

model Ex10_5_a
//The fluid is air

extends Modelica.Math;
// Variables
Real v1(unit ="m^3/kg")                             "Specific volume";
Real v2(unit ="m^3/kg")                             "Specific volume";
Real T2(unit ="K")                                  "Final temperature";
Real Q(unit ="kJ")                                  "Heat transfer";

// Parameters
  parameter Real p2(unit ="bar")=1                 "Pressure";
  parameter Real p1(unit ="bar")=10                "Pressure";
  parameter Real T1(unit ="K")=473                 "Initial temperature";
  parameter Real n(unit ="")=1.15                  "Polytropic index";
  parameter Real R(unit ="kJ/kg*K")=0.287          "Gas constant";
  parameter Real Cv(unit ="kJ/kg*K")=0.716         "Specific heat at constant volume";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

v1=R*T1/(p1*1e02);
v2=(R*T1/(p1*1e02))*((p1/p2)^(1/n));
T2=T1*p2*v2/(p1*v1);
Q=(Cv+(R/(1-n)))*(T2-T1);


//The  answer may slightly vary due to  rounding off values.
end Ex10_5_a;
//==================================================================================================

model Ex10_5_b

extends Modelica.Math;
// Variables
Real v2(unit ="m^3/kg")                      "Specific volume";
Real x2(unit ="")                            "Dryness fraction";
Real u2(unit = "kJ/kg")                      "Internal energy";
Real W(unit ="kJ/kg")                        "Work";
Real Q(unit ="kJ/kg")                        "Heat transfer";

// Parameters
  parameter Real p2(unit ="bar")=1                 "Pressure";
  parameter Real p1(unit ="bar")=10                "Pressure";
  parameter Real v1(unit ="m^3/kg")=0.20596        "Specific volume at state 1";
  parameter Real u1(unit ="kJ/kg")=2621.9          "Internal energy at state 1";
  parameter Real n(unit ="")=1.15                  "polytropic index";
  parameter Real R(unit ="kJ/kg*K")=0.287          "Gas constant";
  parameter Real Cv(unit ="kJ/kg*K")=0.716         "Specific heat at constant volume";
  parameter Real vf(unit = "m^3/kg") =0.001043     "Specific volume";
  parameter Real vg(unit = "m^3/kg") =1.694        "Specific volume";
  parameter Real uf(unit = "kJ/kg")=417.33         "Internal energy";
  parameter Real ufg(unit="kJ/kg")=2088.7          "Internal energy";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

v2=v1*(p1/p2)^(1/n);
x2=(v2-vf)/(vg-vf);
u2=uf+x2*ufg;
W=(p1*v1-p2*v2)/(n-1);
Q=u2-u1+W;

//The  answer provided in the textbook is wrong.
end Ex10_5_b;
//===============================================================================================
end Ex10_5;
