model Ex10_6

extends Modelica.Math;
// Variable
Real n(unit ="")                         "Number of moles of the gas";
Real Cv(unit ="kJ/kg-K")                 "Specific heat at constant volume";
Real Ta(unit ="K")                       "Temperature";       
Real Qab(unit ="J")                      "Heat transfer";
Real Ub(unit ="J")                       "Internal energy";
Real Uab(unit ="J")                      "Internal energy";
Real Ubc(unit ="J")                      "Internal energy";
Real Wbc(unit ="J")                      "Work done";
Real Tc(unit ="K")                       "Temperature";
Real g(unit ="")                         "specific heat ratio";
Real Vcb(unit ="m^3")                    "Volume";
Real Wca(unit ="J")                      "Work done";
Real Qca(unit ="J")                      "Heat transfer";
Real n_(unit ="")                        "Efficiency";

// Parameters

  parameter Real T0(unit ="K")=3                       "Temperature";
  parameter Real P0(unit ="Pa")=1000                   "Pressure";
  parameter Real V0(unit ="m^3")=0.001                 "Specific heat ratio";       
  parameter Real R(unit ="kJ/kg*K")=0.287              "Gas constant";
  parameter Real Tb(unit ="K")=300                     "Temperature";
  parameter Real Ua(unit ="J")=0                       "Internal energy";
  parameter Real Wab(unit ="J")=0                      "Work done";
  parameter Real Qbc(unit ="J")=0                      "Heat transfer";
  parameter Real Uc(unit ="J")=0                       "Internal energy";
  parameter Real Uca(unit ="J")=0                      "Internal energy";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation


n = (P0*V0)/(R*T0); 			// Number of moles

// Process ab

Cv = (3/2)*R;
Ta = T0; 
Qab = n*Cv*(Tb-Ta);
Ub = Qab+Ua;
Uab = Ub-Ua;

// Process bc

Ubc = Uc-Ub;
Wbc = -Ubc;

// Process ca
Tc = Ta;
g = 5/3; 			// gamma
Vcb = (Tb/Tc)^(3/2); 			// Vc/Vb
Wca = -n*R*Tc*log(Vcb);
Qca = Wca ;

n_=(Qab+Qca)/Qab;

end Ex10_6;
