model Ex11_6

extends Modelica.Math;
// Variables

Real Tf(unit ="K")                        "Final temperature";
Real Uf1(unit ="kJ")                      "Energy";
Real Uf2(unit ="kJ")                      "Energy";
Real Pf(unit ="kN/m^2")                   "Final Pressure";
Real Vf1(unit ="m^3")                     "Volume";
Real Vf2(unit ="m^3")                     "Volume";

// Parameters
  

  parameter Real R(unit ="kJ/kg*K")=8.3143       "Gas constant";
  parameter Real N1(unit ="kg/mol")=0.5e-03      "Mole number of system 1";
  parameter Real N2(unit ="kg/mol")=0.75e-03     "Mole number of system 2";
  parameter Real T1(unit ="K")=200               "Temperature";
  parameter Real T2(unit ="K")=300               "Temperature";
  parameter Real V(unit ="m^3")=0.02             "Volume";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
 
Tf = ((N1*T1)+(N2*T2))/(N1+N2); 			
Uf1 = (3/2)*R*N1*Tf;
Uf2 = (3/2)*R*N2*Tf;  //The  answer provided in the textbook is wrong.
Pf = (R*Tf*(N1+N2))/V;
Vf1 = (R*N1*Tf)/Pf;
Vf2 = V - Vf1;

end Ex11_6;
