package Ex12_1

model Ex12_1_a

extends Modelica.Math;
// Variables

Real v1(unit ="m^3/kg")              "Specific Volume";
Real W(unit ="kJ/kg")                "Work done";


// Parameters
  
//steam is a saturated liquid initially.
  parameter Real vf(unit ="m^3/kg")=0.001043               "Specific Volume";
  parameter Real p1(unit ="kPa")=100                       "Pressure";
  parameter Real p2(unit ="kPa")=1000                      "Pressure";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

v1=vf;
W=v1*(p1-p2);


end Ex12_1_a;
//=================================================================================================


model Ex12_1_b

extends Modelica.Math;
// Variables

Real W(unit ="kJ/kg")              "Work done";


// Parameters
  
//steam is a saturated vapour initially.
//from steam tables at 1 bar
  parameter Real p1(unit ="bar")=1                        "Pressure";
  parameter Real h1(unit ="kJ/kg")=2675.5                 "Enthalpy";
  parameter Real s1(unit ="kJ/kg*K")=7.3594               "Entropy";
  //from steam tables at 10 bar
  parameter Real p2(unit ="bar")=10                       "Pressure";
  parameter Real s2(unit ="kJ/kg*K")=7.3594               "Entropy";
  
  //By interploation
   parameter Real h2(unit ="kJ/kg")=3195.5                "Enthalpy";
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation


W=h1-h2;


end Ex12_1_b;

end Ex12_1;
