model Ex12_10

extends Modelica.Math;
// Variables

Real h2(unit ="kJ/kg")                  "Enthalpy";
Real s2(unit ="kJ/kg*K")                "Entropy";
Real s3s(unit ="kJ/kg*K")               "Entropy";
Real h3s(unit ="kJ/kg")                 "Enthalpy";
Real x3s(unit ="")                      "Dryness fraction";
Real h23(unit ="kJ/kg")                 "Enthalpy";
Real h3(unit ="kJ/kg")                  "Enthalpy";
Real h5(unit ="kJ/kg")                  "Enthalpy";
Real w(unit ="kJ/s")                    "Steam flow rate";
Real ws(unit ="kg/s")                   "Steam flow rate";
Real ws_(unit ="kg/h")                  "Steam flow rate";
Real h6(unit ="kJ/kg")                  "Enthalpy";
Real h7(unit ="kJ/kg")                  "Enthalpy";
Real wf(unit ="kg/hr")                  "Fuel burning rate";

// Parameters
  //From steam table, at 40 bar
  parameter Real hfg(unit ="kJ/kg")=2163.8                "Enthalpy";  //h2-h3
  parameter Real h1(unit ="kJ/kg")=3037.3                 "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=191.83                 "Enthalpy";
  parameter Real hf(unit ="kJ/kg")=561.47                 "Enthalpy";  
  parameter Real Wt(unit ="kJ/s")=1500                    "Work done";
  parameter Real Qh(unit ="kJ/s")=3500                    "Heat transfer";
  parameter Real x2(unit ="")=0.96                        "Efficiency of generator";
  parameter Real n_internal(unit ="")=0.80                "Internal Efficiency";
  parameter Real n_boiler(unit ="")=0.85                  "Boiler Efficiency";
  parameter Real CV(unit ="kJ/kg")=44000                  "Calorific value";  
  parameter Real sfg(unit ="kJ/kg*K")=5.3201              "Entropy";  
  parameter Real sf(unit ="kJ/kg*K")=1.6718               "Entropy";
  parameter Real hfg3(unit ="kJ/kg")=2392.8               "Enthalpy";  
  parameter Real hf3(unit ="kJ/kg")=191.83                "Enthalpy";
  parameter Real sfg3(unit ="kJ/kg*K")=7.5009             "Entropy";  
  parameter Real sf3(unit ="kJ/kg*K")=0.6493              "Entropy";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

h2=hf+(x2*hfg);
s2=sf+(x2*sfg);
s3s=s2;
x3s = (s3s-sf3)/sfg3;
h3s = hf3+(x3s*hfg3);
h23 = n_internal*(h2-h3s); 			// h2-h3
h3 = h2-h23;
h5 = hf;
w = Qh/(h2-h5);
ws = (Wt+w*(h2-h3))/(h1-h3); 
ws_ = 3600*ws ; 			
h6 = ((ws-w)*h4+w*h5)/ws;
h7 = h6; 			
//Steam raising capacity of the bolier=1.1*ws kg/h, since 10% of bolier steam is used for auxiliaries.
wf = (1.1*ws_*(h1-h7))/(n_boiler*CV);


end Ex12_10;
