model Ex12_11

extends Modelica.Math;
// Variables

Real h7(unit ="kJ/kg")             "Enthalpy";
Real h4(unit ="kJ/kg")             "Enthalpy";
Real h5(unit ="kJ/kg")             "Enthalpy";
Real h2(unit ="kJ/kg")             "Enthalpy";
Real m(unit ="kg/kg")              "Quantity of steam bled per kg of flow at the turbine inlet";
Real n_cycle(unit ="")             "Cyclic efficiency";

// Parameters
  //From steam table, at 40 bar
  parameter Real h1(unit ="kJ/kg")=3285               "Enthalpy";  
  parameter Real h2s(unit ="kJ/kg")=3010              "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=3280               "Enthalpy";
  parameter Real h4s(unit ="kJ/kg")=3030              "Enthalpy";  
  parameter Real h5s(unit ="kJ/kg")=2225              "Enthalpy";
  parameter Real h6(unit ="kJ/kg")=162.7              "Enthalpy";
  parameter Real h8(unit ="kJ/kg")=762.81             "Enthalpy";
  parameter Real nIP(unit ="")=0.83                   "IP turbine Efficiency";
  parameter Real nHP(unit ="")=0.785                  "HP turbine Efficiency";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

h7=h6;
h4=h3-(nIP*(h3-h4s));
h5=h4-(nIP*(h4-h5s));
h2=h1-(nHP*(h1-h2s));
m = (h8-h7)/(h4-h7);
n_cycle = ((h1-h2)+(h3-h4)+(1-m)*(h4-h5))/((h1-h8)+(h3-h2));


end Ex12_11;
