model Ex12_3

extends Modelica.Math;
// Variables
Real hf(unit ="kJ/kg")                 "Enthalpy";
Real s2(unit ="kJ/kg*K")               "Entropy";
Real s1(unit ="kJ/kg*K")               "Entropy";
Real h2(unit ="kJ/kg")                 "Enthalpy";
Real Wp(unit ="kJ/kg")                 "Pump work";
Real Wt(unit ="kJ/kg")                 "Turbine work";
Real W_net(unit ="kJ/kg")              "Work done";
Real Q1(unit ="kJ/kg")                 "Heat transfer";
Real n(unit ="%")                      "Cyclic efficiency";
Real P2(unit ="bar")                   "Pressure";
Real h4(unit ="kJ/kg")                 "Enthalpy";
Real Tm(unit ="K")                     "Mean temperature";
Real s4(unit ="kJ/kg*K")               "Entropy";

// Parameters
  
//Steam is a saturated liquid initially.
  parameter Real h1(unit ="kJ/kg")=3165.54               "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=173.88                "Enthalpy";
  parameter Real hfg(unit ="kJ/kg")=2403.1               "Enthalpy";
  parameter Real sg(unit ="kJ/kg*K")=8.2287              "Entropy";
  parameter Real sf(unit ="kJ/kg*K")=0.5926              "Entropy";
  parameter Real x2(unit ="")=0.85                       "Dryness fraction";
  parameter Real vf(unit ="m^3/kg")=0.001                "Specific Volume";
  parameter Real P1(unit ="bar")=0.08                    "Pressure";
  
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

hf=h3;
s2=sf+x2*(sg-sf);
s1=s2;
//at 360 degree celsius, sg=5.0526 kJ/kg*K which is less than s1. so from the super heated steam table at 360 degree celsius and s1=7.0833 kJ/kg*K
P2=16.832;                              //By interpolation
h2=hf+x2*hfg;
h4=hf+(P2-P1)*vf*100;
Q1=h1-h4;
Wt=h1-h2;
Wp=h4-h3;
W_net=Wt-Wp;
n=W_net*100/Q1;
s4=sf;
Tm=(h1-h4)/(s1-s4);


end Ex12_3;
