model Ex12_7

extends Modelica.Math;
// Variables
Real wg(unit ="kg/s")                "Mass flow rate of hot gases";
Real af1(unit ="MW")                 "Exergy flow rate of inlet gas";
Real af2(unit ="MW")                 "Exergy flow rate of exhaust gas stream";
Real afi(unit ="MW")                 "Rate of exergy decrease of the gas stream";
Real s2(unit ="kJ/kg*K")             "Entropy";
Real s4(unit ="kJ/kg*K")             "Entropy";
Real Wt(unit ="kJ/kg")               "Turbine work";
Real Wp(unit ="kJ/kg")               "Pump work";
Real Q1(unit ="kJ/kg")               "Heat input";
Real Q2(unit ="kJ/kg")               "Heat output";
Real Wnet(unit ="kJ/kg")             "Net work";
Real ws(unit ="kg/s")                "Mass flow rate of steam";
Real afu(unit ="MW")                 "Rate of exergy increase of steam";
Real I_dot(unit ="MW")               "Rate of exergy destruction in the steam generator";
Real W_net(unit ="MW")               "Rate of useful mechanical power output";
Real afc(unit ="MW")                 "Exergy flow rate of wet steam to the condenser";
Real n2(unit ="%")                   "Second law efficiency";

// Parameters
  //From steam table, at 40 bar 
   
  parameter Real h1(unit ="kJ/kg")=2801                 "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=1890.2               "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=169                  "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=172.8                "Enthalpy";
  parameter Real s1(unit ="kJ/kg*K")=6.068              "Entropy";
  parameter Real s3(unit ="kJ/kg*K")=0.576              "Entropy";
  parameter Real Cpg(unit ="kJ/kg*K")=1.1               "Specific heat";
  parameter Real Q(unit ="kW")=100e03                   "Heat transfer";
  parameter Real Te(unit ="K")=450                      "Exhaust temperature";
  parameter Real To(unit ="K")=300                      "Atmospheric temperature";
  parameter Real Ti(unit ="K")=2000                     "Temperature of hot gases";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

wg = Q/(Cpg*(Ti-Te));
af1 = wg*Cpg*To*1e-03*((Ti/To)-1-log(Ti/To));
af2 = wg*Cpg*To*1e-03*((Te/To)-1-log(Te/To));
afi = af1-af2; 
s2 = s1;
s4 = s3;
Wt = h1-h2;
Wp = h4-h3;
Q1 = h1-h4;
Q2 = h2-h3;
Wnet = Wt-Wp;
ws = Q/Q1;
afu = ws*1e-03*(h1-h4-To*(s1-s3));
I_dot = afi-afu;
W_net = ws*Wnet*1e-03;
afc = ws*(h2-h3-To*(s2-s3))*1e-03;
n2 = 100*W_net/af1;


end Ex12_7;
