model Ex14_2

extends Modelica.Math;
// Variables


Real h4(unit ="kJ/kg")                "Enthalpy";
Real Q2(unit ="kW")                   "Heat removal from the refrigerated space";
Real Wc(unit ="kW")                   "Power input to the compressor";
Real Q1(unit ="kW")                   "Heat rejection rate in the condenser";
Real COP(unit ="")                    "Coefficient of performance";


// Parameters
  parameter Real m(unit ="kg/s")=0.06                    "Mass flow rate of the refigerant";   
  // From the R-134a tables, For p1=0.14 MPa
  parameter Real h1(unit ="kJ/kg")=236.04                "Enthalpy";  
  parameter Real s1(unit ="kJ/kg*K")=0.9322              "Entropy";
  // For p2=0.8 Mpa
  parameter Real s2(unit ="kJ/kg*K")=0.9322              "Entropy";
  parameter Real h2(unit ="kJ/kg")=272.05                "Enthalpy";  
  parameter Real h3(unit ="kJ/kg")=93.42                 "Enthalpy";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

h4=h3;
Q2=m*(h1-h4);
Wc=m*(h2-h1);
Q1=m*(h2-h3);
COP=Q2/Wc;


end Ex14_2;
