model Ex15_3
extends Modelica.Math;
// Variables

Real Pw3(unit ="kPa")                                   "Pressure";
Real Pa3(unit ="kPa")                                   "Pressure";
Real W3(unit ="kg vap/kg dry air")                      "Specific humidity ";
Real Pa1(unit ="kPa")                                   "Pressure";
Real W1(unit ="kg vap/kg dry air")                      "Specific humidity ";
Real W2(unit ="kg vap/kg dry air")                      "Specific humidity ";
Real va3(unit ="m^3/kg dry air")                        "Specific volume";
Real SW(unit ="kg moisture/m^3")                        "Spray water";
Real t2(unit ="degree celsius")                         "Temperature";


// Parameters
  parameter Real P(unit ="kPa")=101.3                     "Atmospheric pressure";   
  parameter Real Psat(unit ="kPa")=2.339                  "Saturation Pressure";
  parameter Real fi3(unit ="")=0.5                        "Relative humidity";  
  parameter Real T3(unit ="K")=293                        "Temperature";
  parameter Real t3(unit ="degree celsius")=20            "Temperature";
  parameter Real Pw1(unit ="kPa")=0.7156                  "Pressure";
  parameter Real Psat_1(unit ="kPa")=0.7156               "Saturated Pressure";
  parameter Real Cp(unit ="kJ/kg*K")=1.005                "Specific heat at constant pressure";
  parameter Real hg(unit ="kJ/kg-K")=2518                 "Enthalpy";
  parameter Real h4(unit ="kJ/kg-K")=10                   "Enthalpy";
  parameter Real tsat(unit ="degree celsius")=9.65        "Saturation temperature";
  parameter Real Ra(unit ="kJ/kg*K")=0.287                "Gas constant";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

Pw3 = fi3*Psat;
Pa3 = P-Pw3;
W3 = 0.622*(Pw3/Pa3);
Pa1 = P-Pw1;
W1 = 0.622*(Pw1/Pa1); 
W2 = W1;
va3 = (Ra*T3)/Pa3;
SW = (W3-W1)/va3; 
t2 = ( W3*(hg+1.884*(t3-tsat))-W2*(hg-1.884*tsat) + Cp*t3 - (W3-W2)*h4 )/ (Cp+W2*1.884);

end Ex15_3;
