model Ex15_5

extends Modelica.Math;
// Variables
Real G12(unit ="")                                       "Flow rate ratio";
Real W3(unit ="kg vap/kg dry air")                       "Specific humidity";
Real h3(unit ="kJ/kg dry air")                           "Enthalpy";


// Parameters
  parameter Real h1(unit ="kJ/kg")=35                     "Enthalpy";   
  parameter Real h2(unit ="kJ/kg")=90                     "Enthalpy";
  parameter Real G1(unit ="kg")=1                         "Flow rate";  
  parameter Real G2(unit ="kg")=2                         "Flow rate";
  parameter Real W1(unit ="kg vap/kg dry air")=0.0058     "Specific humidity";
  parameter Real W2(unit ="kg vap/kg dry air")=0.0187     "Specific humidity";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

G12 = G1/G2; 			
W3 = (W2+G12*W1)/(1+G12);
h3 = (2/3)*h2 + (1/3)*h1;


end Ex15_5;
