model Ex15_6

extends Modelica.Math;
// Variables
Real T2(unit ="degree celsius")           "Temperature of air at the end of the drying process";
Real Q(unit ="kJ/kg dry air")             "Heat rejected during the cooling process";
Real fi3(unit ="%")                       "Relative humidity at the end of the cooling process";
Real t4(unit ="degree celsius")           "Dew point temperature at the end of the drying process";
Real W1_2(unit ="kg vap/kg dry air")      "Moisture removed during the drying process";


// Parameters
  parameter Real h1(unit ="kJ/kg")=60.5                       "Enthalpy";   
  parameter Real h3(unit ="kJ/kg")=42                         "Enthalpy";
  parameter Real W1(unit ="kg vap/kg dry air")=0.0153         "Specific humidity";
  parameter Real W2(unit ="kg vap/kg dry air")=0.0083         "Specific humidity";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

T2=38.5;   //from psychrometric chart
Q=h1-h3;
fi3=53;
t4=11.2;
W1_2=W1-W2;


end Ex15_6;
