package Ex16_12
 
model Ex16_12_a

extends Modelica.Math;
// Variable

Real A(unit ="kJ/kg-mol")                      "Chemical exergy of Carbon";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg*K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon di oxide";
  parameter Real g_O2(unit ="")=0                     "";
  parameter Real g_C(unit ="")=0                      "";
  parameter Real g_CO2(unit ="")=-394380              "";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

A = -g_CO2 + R*T0*log(x_O2/x_CO2);

end Ex16_12_a;
//================================================================================================

model Ex16_12_b

extends Modelica.Math;
// Variable

Real B(unit ="kJ/kg-mol")                      "Chemical exergy of Hydrogen";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg*K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon di oxide";
  parameter Real g_H2(unit ="")=0                     "";
  parameter Real g_H2O(unit ="")=-228590              "";
  parameter Real g_O2(unit ="")=0                     "";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

B = g_H2 + g_O2/2 - g_H2O + R*T0*log((x_O2^0.5)/x_H2O);

end Ex16_12_b;
//====================================================================================================
model Ex16_12_c

extends Modelica.Math;
// Variable

Real C(unit ="kJ/kg-mol")                      "Chemical exergy of Methane";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg*K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon di oxide";
  parameter Real g_CO2(unit ="")=-394380              "";
  parameter Real g_H2O(unit ="")=-228590              "";
  parameter Real g_O2(unit ="")=0                     "";
  parameter Real g_CH4(unit ="")=-50790               "";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation


C = g_CH4 + 2*g_O2 - g_CO2 - 2*g_H2O + R*T0*log((x_O2^2)/(x_CO2*x_H2O));
//Answer may vary due to rounding off error.
end Ex16_12_c;

//================================================================================================
model Ex16_12_d

extends Modelica.Math;
// Variable

Real D(unit ="kJ/kg-mol")                      "Chemical exergy of Carbon monoxide";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg-K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon di oxide";
  parameter Real g_CO2(unit ="")=-394380              "";
  parameter Real g_CO(unit ="")=-137150               "";
  parameter Real g_O2(unit ="")=0                     "";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation


D =  g_CO + g_O2/2 - g_CO2 + R*T0*log((x_O2^0.5)/x_CO2);


end Ex16_12_d;
//================================================================================================
model Ex16_12_e

extends Modelica.Math;
// Variable

Real E(unit ="kJ/kg-mol")                      "Chemical exergy of Liquid methanol";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg-K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon di oxide";
  parameter Real g_CO2(unit ="")=-394380              "";
  parameter Real g_CH3OH(unit ="")=-166240            "";
  parameter Real g_H2O(unit ="")=-228590              "";
  parameter Real g_O2(unit ="")=0                     "";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

E = g_CH3OH + 1.5*g_O2 - g_CO2 - 2*g_H2O + R*T0*log((x_O2^1.5)/(x_CO2*(x_H2O^2)));

//Answer may vary due to rounding off error.
end Ex16_12_e;


//========================================================================================
model Ex16_12_f

extends Modelica.Math;
// Variable

Real F(unit ="kJ/kg-mol")                      "Chemical exergy of Nitrogen";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg-K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon di oxide";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

F = R*T0*log(1/x_N2);


end Ex16_12_f;
//=============================================================================================
model Ex16_12_g

extends Modelica.Math;
// Variable

Real G(unit ="kJ/kg-mol")                      "Chemical exergy of Oxygen";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg-K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon dioxide";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

G = R*T0*log(1/x_O2);


end Ex16_12_g;
//=============================================================================================
model Ex16_12_h

extends Modelica.Math;
// Variable

Real H(unit ="kJ/kg-mol")                      "Chemical exergy of Carbon dioxide";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg*K")=8.3143            "Charaterstics gas constant";
  parameter Real x_N2(unit ="")=0.7567                "% of Nitrogen";
  parameter Real x_O2(unit ="")=0.2035                "% of Oxygen";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real x_CO2(unit ="")=0.0003               "% of carbon di oxide";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

H = R*T0*log(1/x_CO2);


end Ex16_12_h;
//=========================================================================================

model Ex16_12_i

extends Modelica.Math;
// Variable

Real I(unit ="kJ/kg-mol")                      "Chemical exergy of Water";

// Parameters

  parameter Real T0(unit ="K")=298.15                 "Temperature";  
  parameter Real P0(unit ="bar")=1                    "Pressure";  
  parameter Real R(unit ="kJ/kg*K")=8.3143            "Charaterstics gas constant";
  parameter Real x_H2O(unit ="")=0.0312               "% of water";
  parameter Real g_H2O(unit ="")=-228590              "";
  parameter Real g_H2O_1(unit ="")=-237180                     "";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation


I = g_H2O_1 - g_H2O + R*T0*log(1/x_H2O);


end Ex16_12_i;
//===============================================================================================

end Ex16_12;