model Ex16_3

extends Modelica.Math;
// Variable

Real v2(unit ="")                       "";
Real v3(unit ="")                       "";       
Real v4(unit ="")                       "";
Real x1(unit ="")                       "";
Real x2(unit ="")                       "";
Real x3(unit ="")                       "";
Real x4(unit ="")                       "";
Real K(unit ="")                        "Equillibrium constant";
Real dG(unit ="J/g-mol")                "Gibbs function change";

// Parameters

  parameter Real v1(unit ="")=1                 "";   
  parameter Real e_(unit ="")=0.56              "Degree of reaction ";   
  parameter Real P(unit ="mm Hg")=1             "Dummy";   
  parameter Real T(unit ="K")=1200              "Temperature";
  parameter Real R(unit ="bar")=8.3143          "Gas constant";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

v2 = v1; 
v3 = v2; 
v4 = v2;
x1 = (1-e_)/2; 
x2 = (1-e_)/2;
x3 = e_/2; 
x4 = e_/2;
K = (((x3^v3)*(x4^v4))/((x1^v1)*(x2^v2)))*P^(v3+v4-v1-v2); 			 
dG = -R*T*log(K);


end Ex16_3;
