model Ex16_5

extends Modelica.Math;
// Variable

Real e_(unit ="")                                   "Degree of dissociation";
Real K(unit ="atm")                                 "Equillibrium constant";

// Parameters

  parameter Real Veo(unit ="")=1.777                 "Volume ratio";  //Ve/Vo 
  parameter Real P(unit ="atm")=0.124                "Dummy"; 
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

e_ = 1-Veo; 	

K = (4*e_^2*P)/(1-e_^2);

end Ex16_5;
