model Ex16_9


// Variable

Real Hr(unit ="kJ/kg mol fuel")          "Reactants energy";
Real Hp(unit ="kJ/kg mol fuel")          "Products energy";
Real Wcv(unit ="kW")                     "Energy out put from engine";
Real Qcv(unit ="kW")                     "Heat transfer from engine";
Real n(unit ="kg-mol/h")                 "Fuel be consumed per second";
Real FCR(unit ="kg/h")                   "Fuel consumption rate";


// Equations
equation
//Below values are taken fron table 16.4
Hr = -249952.+(18.7*560)+(70*540);
Hp = 8.*(-393522.+20288)+9*(-241827+16087)+6.25*14171+70*13491;
Wcv = 150.; 			
Qcv = -205.; 			
n = (Wcv-Qcv)*3600/(Hr-Hp);
FCR=n*114;

// The  answer may slightly vary due to  rounding off values.

end Ex16_9;
