model Ex17_1

extends Modelica.Math;
// Variable
Real M(unit ="")                      "Mach number";
Real T0_T(unit ="")                   "Temperature ratio";
Real T(unit ="K")                     "Temperature";       
Real c(unit ="m/s")                   "Speed velocity";
Real V(unit ="m/s")                   "Velocity";
Real p0_p(unit ="")                   "Pressure ratio";
Real p0(unit ="kPa")                  "Stagnation Pressure";

// Parameters

  parameter Real T0(unit ="K")=310                   "Temperature";
  parameter Real p(unit ="kPa")=40                   "Pressure";
  parameter Real y(unit ="")=1.4                     "Specific heat ratio";       
  parameter Real R(unit ="kJ/kg*K")=0.287            "Gas constant";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation


M^4+5*M^2=3.225;
T0_T=1+((y-1)*M^2/2);
T=T0/T0_T;
c=sqrt(y*R*T*1e03);
V=c*M;
p0_p=(T0_T)^(y/(y-1));
p0=p0_p*p;


end Ex17_1;
