model Ex17_5

extends Modelica.Math;
// Variables
Real Px(unit ="kPa")                     "Static pressure upstream of the shock";
Real Py(unit ="kPa")                     "Static pressure downstream of the shock";
Real Poy(unit ="kPa")                    "pressure";
Real A2_A(unit ="")                      "Area ratio";       //A2/A*
Real P2(unit ="kPa")                     "Exit pressure";
Real delta_P(unit ="kPa")                "Loss in stagnation pressure occurs only across the shock";
Real syx(unit ="kJ/kg*K")                "Entropy increases";




// Parameters
  parameter Real Ax(unit ="cm^2")=18.75                  "Cross-sectional area of nozzle";   
  parameter Real A_(unit ="cm^2")=12.50                  "Throat area";   // A_= A*
  parameter Real AA_(unit ="")=1.5                       "Area ratio";   // A/A*
  // from the gas table on normal shock
  parameter Real Mx(unit ="")=1.86                  "Mach number";
  parameter Real Pxox(unit ="")=0.159               "Pressure ratio";    //Px/Pox
  parameter Real Pyx(unit ="")=3.87                 "Pressure ratio";    //Py/Px
  parameter Real R(unit ="kJ/kg*K")=0.287           "Gas constant";
  parameter Real Pox(unit ="")=0.21e03              "Pressure ratio";     //Po/Px
  parameter Real My(unit ="")=0.604                 "Mach number";
  parameter Real Poyx(unit ="")=4.95                "pressure ratio";     //Poy/Px
  parameter Real Poyox(unit ="")=0.786              "pressure ratio";    //Poy/Pox
  parameter Real Ay_A(unit ="")=1.183               "Area ratio";        //Ay/A*
  parameter Real A2(unit ="cm^2")=25                "Exit area";
  parameter Real Ay(unit ="cm^2")=18.75             "Area";
  parameter Real M2(unit ="")=0.402                 "Mach number";
  parameter Real P2oy(unit ="")=0.895               "pressure ratio";     //P2/Poy
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

Px = Pxox*Pox;
Py = Pyx*Px;
Poy = Poyx*Px;
A2_A = (A2/Ay)*Ay_A;                         //A2/A*
P2 = P2oy*Poy;
delta_P=Pox-Poy;
syx = -R*log(Poy/Pox); 			// sy-sx



end Ex17_5;
