model Ex17_6

extends Modelica.Math;
// Variables
Real T1(unit ="K")                       "Temperature";
Real P_(unit ="bar")                     "Pressure";
Real P1(unit ="bar")                     "pressure";
Real P2(unit ="bar")                     "pressure";       
Real T2(unit ="K")                       "Exit temperature";
Real V2(unit ="m/s")                     "Exit velocity";
Real m_dot(unit ="kg/s")                 "Mass flow rate";




// Parameters

  parameter Real P0(unit ="kPa")=1.4                "Stagnation pressure";
  parameter Real T0(unit ="K")=280                  "Stagnation Temperature";
  parameter Real d(unit ="")=1.4                    "";
  parameter Real R(unit ="kJ/kg*K")=0.287           "Gas constant";
  parameter Real y(unit ="")=1.4                    "Specific heat ratio";
  parameter Real Cp(unit ="kJ/kg*K")=1.005          "Specific heat at constant pressure";
  parameter Real A2(unit ="m^2")=0.0013             "Exit area";
  parameter Real Pb(unit ="bar")=1                  "Atmospheric pressure";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
 		
T1 = T0;
P_ = P0/((y+1)/2)^(d/(d-1)) ; 			// P_ = P*
P1 = P0; 
P2 = Pb;
T2 = T1*(P2/P1)^((d-1)/d);
V2 = sqrt(2*Cp*(T1-T2)*1000);
m_dot = (A2*V2*P2*100)/(R*T2);


end Ex17_6;
