model Ex17_8

extends Modelica.Math;
// Variable

Real Tox(unit ="K")                     "Temperature";
Real Pox(unit ="bar")                   "Pressure";       
Real Px(unit ="bar")                    "Pressure";
Real Py(unit ="bar")                    "Pressure";
Real Poy(unit ="bar")                   "Pressure";
Real Toy(unit ="K")                     "Temperature";
Real A1(unit ="m^2")                    "Area";
Real A_(unit ="m^2")                    "Area";
Real A2(unit ="m^2")                    "Area";


// Parameters
  parameter Real M1(unit ="")=0.39                     "Mach number";
  parameter Real V1(unit ="m/s")=180                   "Velocity";
  parameter Real T1(unit ="K")=530                     "Temperature";
  parameter Real T1ox(unit ="")=0.97032                "Temperature ratio";       //T1/Tox
  parameter Real P1ox(unit ="")=0.9                    "pressure ratio";          //P1/Pox
  parameter Real Mx(unit ="")=2                        "Mach number";
  parameter Real Pxox(unit ="")=0.1278                 "pressure ratio";          //Px/Pox
  parameter Real Pxy(unit ="")=4.5                     "pressure ratio";          //Px/Py
  parameter Real My(unit ="")=0.57735                  "Mach number";
  parameter Real Pyoy(unit ="")=0.79737                "pressure ratio";          //Py/Poy
  parameter Real m(unit ="kg/s")=0.5                   "Mass flow rate of air";
  parameter Real R(unit ="kJ/kg*K")=0.287              "Gas constant";
  parameter Real P1(unit ="bar")=3.4                   "pressure";
  parameter Real A1_(unit ="")=1.6346                  "Area ratio";              //A1/A*
  parameter Real A2_(unit ="")=1.25                    "Area ratio";              //A2/A*
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

Tox=T1/T1ox;
Pox=P1/P1ox;
Px=Pxox*Pox;
Py=Px*Pxy;
Poy=Py/Pyoy;
Toy=Tox;
A1=m*R*T1/(V1*P1*100);
A_=A1/A1_;           //at M1=0.39
A2=A_*A2_;


end Ex17_8;
