model Ex18_1

extends Modelica.Math;
// Variable
Real R(unit ="kJ/kg*K")                       "Gas constant";
Real rp(unit ="")                             "Pressure ratio";
Real V1(unit ="m^3")                          "Swept volume";       
Real W(unit ="J")                             "Work done";
Real IP(unit ="kW")                           "Indicated power";
Real SP(unit ="kW")                           "Shaft power";
Real V1_dot(unit ="m^3/s")                    "Volume flow rate";
Real m_dot(unit ="kg/s")                      "Mass flow rate";
Real rp_1(unit ="")                           "Overall pressure ratio";
Real V2(unit ="m^3")                          "Volume delivered per cycle";
Real d(unit ="m")                             "Diameter";


// Parameters

  parameter Real T2(unit ="K")=488                  "Temperature";
  parameter Real T1(unit ="K")=298                  "Temperature";
  parameter Real n(unit ="")=1.3                    "Polytropic index";
  parameter Real R_(unit ="J/kg*K")=8314            "Charactistics gas constant";
  parameter Real M(unit ="")=44                     "Mach number";
  parameter Real b(unit ="m")=0.12                  "Bore of compressor";
  parameter Real L(unit ="m")=0.15                  "Stroke of compressor";
  parameter Real P1(unit ="Pa")=120e03              "pressure";
  parameter Real N(unit ="rpm")=1200                "Driven speed";
  parameter Real nm(unit ="")=0.8                   "Mechanical efficiency";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

R =R_/M;
rp = (T2/T1)^(n/(n-1));			
V1 = (pi/4)*(b)^2*L ;			
W = ((n*P1*V1)/(n-1))*(((rp)^((n-1)/n))-1);
IP = (W*N*0.001)/60 ; 
SP=IP/nm;
V1_dot = V1*(N/60);
m_dot = (P1*V1_dot)/(R*T1);
rp_1 = rp^2;
V2 = (1/rp)^(1/n)*V1;
d =sqrt((V2*4)/(L*pi));

end Ex18_1;
