model Ex18_10

extends Modelica.Math;
// Variable

Real T2s(unit ="K")                          "Temperature";
Real T2(unit ="K")                           "Temperature";       
Real mg(unit ="kg/s")                        "Mass of air fuel mixture";
Real P(unit ="kW")                           "Power to drive the compressor";
Real T02(unit ="K")                          "Stagnation Temperature";
Real P2(unit ="bar")                         "Pressure";
Real P02(unit ="bar")                        "Stagnation Pressure";

// Parameters

  parameter Real T1(unit ="K")=278              "Temperature";   
  parameter Real P21(unit ="")=2.5              "Pressure ratio";   //P2/P1
  parameter Real V2(unit ="m/s")=120            "Exit velocity";   
  parameter Real ns(unit ="")=0.84              "Isentropic efficiency";
  parameter Real y(unit ="")=1.39               "Index";
  parameter Real af(unit ="")=13                "Air fuel ratio";
  parameter Real fc(unit ="kg fuel/s")=0.04     "Fuel consumption";
  parameter Real Cp(unit ="kJ/kg-K")=1.005      "Specific heat at constant pressure";
  parameter Real P1(unit ="bar")=0.6            "Pressure";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

T2s = T1*(P21)^((y-1)/y);
T2 = T1 + (T2s-T1)/ns;
mg = fc*(af+1);
P = mg*Cp*(T2-T1);
T02 = T2 + V2^2/(2*Cp*1000);
P2 = P21*P1;
P02 = P2*(T02/T2)^(y/(y-1));

end Ex18_10;
