model Ex18_4

extends Modelica.Math;
// Variable

Real p2(unit ="bar")                             "Pressure";
Real W(unit ="kW")                               "Minimum power required by the compressor";       
Real L(unit ="m")                                "Stroke length of piston";
Real LPSV(unit ="m^3")                           "LP swept volume";
Real D_LP(unit ="m")                             "LP Bore diameter";
Real D_HP(unit ="m")                             "HP Bore diameter";


// Parameters

  parameter Real p1(unit ="bar")=1.013                "Pressure";
  parameter Real V1(unit ="m^3/min")=4                "Volume of air";
  parameter Real p4(unit ="bar")=80                   "Pressure";
  parameter Real n_mech(unit ="")=0.75                "Mechanical efficiency";
  parameter Real n_vol(unit ="")=0.8                  "Volumetric efficiency";
  parameter Real n(unit ="")=1.25                     "Polytrpic index";
  parameter Real N(unit ="rpm")=250                   "Compressor speed";
  parameter Real V(unit ="m/s")=3                     "Piston speed";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

p2=sqrt(p1*p4);
W=(2*n/(n-1))*p1*100*(V1/60)*(((p2/p1)^((n-1)/n))-1)/n_mech;
L=(V*60)/(2*N);
LPSV=4/N;
D_LP=sqrt((LPSV*4)/(pi*L*n_vol));
D_HP=sqrt(p1/p2)*D_LP;


end Ex18_4;
