model Ex18_5

extends Modelica.Math;
// Variable

Real T2(unit ="K")                             "Temperature";
Real p2(unit ="kPa")                           "pressure";       
Real V2(unit ="m^3")                           "Volume";
Real v2(unit ="m^3/kg")                        "Specific volume";
Real A(unit ="kJ/kg")                          "Area of actual indicator diagram";
Real IO(unit ="kJ")                            "Indicated output";


// Parameters

  parameter Real V12(unit ="")=0.4                  "Volume ratio";   //V12=V1/V2
  parameter Real T1(unit ="K")=311                  "Temperature";
  parameter Real p3(unit ="kPa")=112                "back pressure";
  parameter Real m(unit ="kg")=1.25                 "Air mass";
  parameter Real R(unit ="kJ/kg*K")=0.287           "Gas constant";
  parameter Real n(unit ="")=1.3                    "Polytrpic index";
  parameter Real p1(unit ="kPa")=700                "Pressure";
  parameter Real a(unit ="m/s")=0.85             "Area of actual indicator diagram is 0.85 of that outlined above";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

T2 = ((V12)^(n-1))*T1;
p2 = p1*(V12)^n;
V2 = (m*R*T2)/p2;
v2 = V2/m ;
A = R*T1 + R*(T1-T2)/(n-1) - p3*v2; 			
IO = A*a*m;


end Ex18_5;
