model Ex18_6

extends Modelica.Math;
// Variable

Real P21(unit ="")                             "Pressure ratio";
Real P2(unit ="bar")                           "Pressure";       
Real P3(unit ="bar")                           "Pressure";
Real P11(unit ="bar")                          "Pressure";
Real P12(unit ="bar")                          "Pressure";
Real Vs(unit ="kJ")                            "Swept volume of LP cylinder";
Real V11(unit ="m^3")                          "Clearance volume";
Real V1(unit ="m^3")                           "Volume";
Real V12(unit ="m^3")                          "Volume";
Real T3(unit ="K")                             "Temperature";
Real T5(unit ="K")                             "Temperature";
Real P43(unit ="")                             "Pressure";
Real T6(unit ="K")                             "Delivery temperature";
Real V6_7(unit ="")                            "Volume ratio";
Real W(unit ="kJ")                             "Work per kg air";

// Parameters

  parameter Real P1(unit ="bar")=1             "Pressure";   
  parameter Real P41(unit ="")=15              "Pressure";  //P41=P4/P1;
  parameter Real b(unit ="m")=0.45             "Bore  of cylinder";
  parameter Real L(unit ="m")=0.3              "stroke of cylinder";
  parameter Real R(unit ="kJ/kg*K")=0.29       "Gas constant";
  parameter Real n(unit ="")=1.3               "Polytrpic index";
  parameter Real P4(unit ="bar")=15            "Delivery pressure";
  parameter Real T1(unit ="K")=291             "Temperature";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation
P21 = (P41)^(1/3);                 //P2/P1
P2 = P21*P1;
P3 = P21*P2;
P11 = P2; 
P12 = P1;
Vs = (pi/4)*b^2*L; 			
V11 = 0.05*Vs; 			
V1 = V11+Vs;
V12 = V11*(P11/P12)^(1/n);
T3 = T1; 
T5 = T1;
P43 = P21; 			// P4/P3
T6 = T5*(P43)^((n-1)/n);
V6_7 = (P1/P4)*(T6/T1)*(V1-V12);                        //V6-V7
W = ((3*n*R*T1)/(n-1))*((P21)^((n-1)/n)-1);

end Ex18_6;
