model Ex18_8

extends Modelica.Math;
// Variable

Real P2(unit ="bar")                          "Pressure";
Real V_dot(unit ="m^3/s")                     "Volume of air";       
Real PRb(unit ="kW")                          "Power required by the roots blower";
Real P2v(unit ="bar")                         "Pressure";
Real V2_dot(unit ="m^3/s")                    "Volume";
Real PRv(unit ="kW")                          "Power required";

// Parameters

  parameter Real m_dot(unit ="kg/s")=1               "Mass flow rate";   
  parameter Real R(unit ="kJ/kg-K")=0.29             "Gas constant";  
  parameter Real T1(unit ="K")=343                   "Temperature";
  parameter Real P1(unit ="bar")=100                 "Pressure";
  parameter Real y(unit ="")=1.4                     "Index";
  parameter Real P1v(unit ="bar")=1                  "Pressure";
  parameter Real P3v(unit ="bar")=2                  "Pressure";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation 

P2 = 2*P1; 
V_dot = (m_dot*R*T1)/P1;
PRb = V_dot*(P2-P1);
V2_dot = 0.7*V_dot;
P2v = P1v*((V_dot/V2_dot)^y);
PRv = (y/(y-1))*P1*V_dot*( (P2v/P1v)^((y-1)/y) - 1) + V2_dot*(P3v - P2v)*P1;


end Ex18_8;
