model Ex3_5

extends Modelica.Math;

// Variables
Real A(unit="m^2")                            "Area of cylinder";
Real Pm(unit="MPa")                           "Effective pressure";
Real W1(unit="MJ")                            "Work done in 1 minute";
Real W(unit="MW")                             "Rate of work transfer gas to the piston";

// Parameters
 parameter Real ad(unit="m^2")=5.5e-04        "Area of indicator diagram";
 parameter Real l(unit="m")=0.06              "Length of diagram";
 parameter Real k(unit="MPa/m")=147           "Spring constant";
 parameter Real N(unit="rpm")=150             "Speed of engine";
 parameter Real d(unit="m")=0.8               "Diameter of the cylinder";
 parameter Real L(unit="m")=1.2               "Stroke of piston";
 

 final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

A = (pi/4)*(d^2);        	 // Area of cylinder
Pm = (ad/l)*k; 		         // Effective pressure
W1 = Pm*L*A*N; 			     // Work done in 1 minute
W = (12*W1)/60; 			 //Rate of work transfer gas to the piston in MJ/s

//The  answer may slightly vary due to  rounding off values.
end Ex3_5;
